<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Save;

trait TraitPostSaveSetters
{
    use TraitPostSaveProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setSavedPostId(string $savedPostId)
    {
        $this -> savedPostId = $savedPostId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setSavedByUserId(string $savedByUserId)
    {
        $this -> savedByUserId = $savedByUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setSavedToCollectionId(string $savedToCollectionId)
    {
        $this -> savedToCollectionId = $savedToCollectionId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
